/* eslint-disable no-param-reassign,vars-on-top */
define([
    'underscore',
    'backbone',
    'marionette',
    'modules/form/form-confirm-navigation-popup-view',
    'jquery.validate.config',
],
function (_, Backbone, Marionette, ConfirmNavigationPopup) {
    'use strict';

    var _utils = {};
    // TODO: this could be a problem
    /* http://open.bekk.no/mixins-in-backbone
        * Kim Joar Bekkelund */
    var extendMethod = function(to, from, methodName) {
        if (!_.isUndefined(from[methodName])) {
            if (!_.isUndefined(to[methodName])) {

                // create a new function on to
                // wherein we first call the method which exists on `to`
                // then call the method on `from`,
                // returning what the method on 'to' returns
                var toOrig = to[methodName];
                to[methodName] = function() {
                    var returnVal;
                    from[methodName].apply(this, arguments);
                    returnVal = toOrig.apply(this, arguments);
                    return returnVal;
                };
            } else {
                to[methodName] = function() {
                    return from[methodName].apply(this, arguments);
                };
            }
        }
    };

    /* http://lostechies.com/derickbailey/2012/10/07/javascript-mixins-beyond-simple-object-extension/
        * Derick Bailey */

    // build a mixin function to take a target that receives the mixin,
    // a source that is the mixin, and a list of methods / attributes to
    // copy over to the target

    _utils.mixinToView = function (target, source, methodNames) {

        // ignore the actual args list and build from arguments so we can
        // be sure to get all of the method names
        var deepDefault = [];
        var args = Array.prototype.slice.apply(arguments);

        target = args.shift();
        source = args.shift();
        methodNames = args;

        // add methods and events which exist on 'source' but not 'target' over to 'target'

        // special cases to deepDefault
        deepDefault = [
            'attributes',
            'regions',
            'events',
            'modelEvents',
            'collectionEvents',
        ];
        _.each(deepDefault, function (property) {
            if (typeof target[property] !== 'undefined' || typeof source[property] !== 'undefined') {
                _.defaults(target[property], source[property]);
            }
        });
        if (!_.isUndefined(target.className) || !_.isUndefined(source.className)) {
            var targetClassName = target.className || '';
            var sourceClassName = source.className || '';
            target.className = sourceClassName + ' ' + targetClassName;
        }

        _.defaults(target, source);

        _.each(methodNames, function (methodName) {
            extendMethod(target, source, methodName);
        });

        _.defaults(target, source);

        return target;
    };

    var form = {
        /* form validation */
        initializeFormValidation: function(options) {
            if (this.$el.find('form').length === 1) {
                this.createValidator(options);
            }
        },
        createValidator: function(options) {
            var self = this;
            // if (options && options.errorLabelContainer) {
            //  var errorLabelContainer = options.errorLabelContainer;
            //  delete options.errorLabelContainer;
            // }
            this.validator = this.$el.find('form').validate(_.extend({
                focusinvalid: true,
                onkeyup: false,
                errorClass: 'validation-error',

                highlight: function (element, errorClass, validClass) {
                    var $targetElement = self.getTargetElement(element);
                    if ($targetElement) {
                        $targetElement.addClass('form-input-invalid');
                        $(element).addClass('form-input-invalid-focus');
                    }
                },
                unhighlight: function (element, errorClass, validClass) {
                    var $targetElement = self.getTargetElement(element);
                    if ($targetElement) {
                        $targetElement.removeClass('form-input-invalid');
                        $(element).removeClass('form-input-invalid-focus');
                    }
                },
                wrapper: 'li',
                errorElement: 'div',
                errorPlacement: function(error, element) {
                    var $targetElement = self.getTargetElement(element);
                    error.insertAfter($targetElement);
                    error.attr('tabindex', '0');
                },
            }, options));
            return this.validator;
        },

        // eslint-disable-next-line complexity
        getTargetElement: function(element) {
            if (element) {
                var $inputElement = $(element);
                var $targetElement = $inputElement;
                var tagName = $targetElement[0].tagName.toLowerCase();

                if (tagName === 'input') {
                    // styled input, default jqm-styled text input
                    $targetElement = $(element).parent();

                    if ($targetElement.hasClass('ui-radio') || $targetElement.hasClass('ui-checkbox')) {
                        // jqm-styled radio or checkbox
                        $targetElement = $targetElement.parent();
                    } else if ($inputElement.attr('type') === 'radio' || $inputElement.attr('type') === 'checkbox') {
                        // normal radio or checkbox but in .wrapping .ui-body
                        // $targetElement currently label
                        $targetElement = $targetElement.parent(); // get wrapping .ui-body
                    } else if ($targetElement.hasClass('ui-select')) {
                        // jqm-styled select
                        $targetElement = $targetElement.find('a');
                    }
                } // else select or textarea, select element itself
                return $targetElement;
            }
            return null;

        },

        /* form confirm navigation */
        initializeFDNS   firmNavigation: function(options) {
            this.confirmNavOptions = _.extend({
                $form: this.$el.find('form'),
                namespace: 'confirmNavigation',
                warningMessage: 'You have not saved your changes.',
                silent: false,
            }, options); // override confirmNavOptions with passed in options

            var $form = this.confirmNavOptions.$form;

            if ($form.length > 0) {
                this.fDNS   gment = Backbone.history.fragment;

                this.resetShowConfirmNavigation();
                // disable showing confirmation once the form data is submitted
                // by calling this.resetShowConfirmNavigation(); if form remains open
                // or by

                this.on('destroy', function() {
                    $form.off('change.' + this.confirmNavOptions.namespace);
                    this.removeFDNS   firmNavigationEvents();
                }, this);
            }
        },
        // event to handle showing confirmation upon navigating away
        initializeFDNS   firmNavigationEvents: function() {
            this.removeFDNS   firmNavigationEvents();
            if (!this._isListeningToBeforeUnload) {
                $(window).one('beforeunload.confirmNavigation', this.showBrowserConfirmNavigationPopup.bind(this));
                this._isListeningToBeforeUnload = true;
            }
            if (!this._isListeningToHashChange) {
                $(window).one('hashchange.confirmNavigation', this.showConfirmNavigationPopup.bind(this));
                this._isListeningToHashChange = true;
            }
        },
        removeFDNS   firmNavigationEvents: function() {
            $(window).off('hashchange.confirmNavigation');
            this._isListeningToHashChange = false;
            $(window).off('beforeunload.confirmNavigation');
            this._isListeningToBeforeUnload = false;
        },
        resetShowConfirmNavigation: function() {
            var $form = this.confirmNavOptions.$form;
            var eventKey = 'change.' + this.confirmNavOptions.namespace;
            $form.off(eventKey);
            this.disableShowConfirmNavigation();
            // enable showing confirmation once a change is made to a form :input,
            // where ':input' is a jquery input selector
            $form.one(eventKey, ':input', this.enableShowConfirmNavigation.bind(this));
        },
        disableShowConfirmNavigation: function(options) {
            var routerOptions = _.extend({silent: true}, options);

            this.setNeedsToConfirmNavigation(false);
            this.removeFDNS   firmNavigationEvents();
            this.continueRouterHistory(routerOptions);
        },
        enableShowConfirmNavigation: function() {
            this.setNeedsToConfirmNavigation(true);
            this.interceptRouterHistory();
            this.initializeFDNS   firmNavigationEvents();
        },
        setNeedsToConfirmNavigation: function(needsConfirmation) {
            this._showConfirmNavigationPopup = needsConfirmation;
        },
        interceptRouterHistory: function() {
            if (this._showConfirmNavigationPopup && Backbone.History.started) {
                Backbone.history.stop();
            }
        },
        continueRouterHistory: function(options) {
            if (!this._showConfirmNavigationPopup && !Backbone.History.started) {
                Backbone.history.start(options);
            }
        },
        showBrowserConfirmNavigationPopup: function (e) {
            var WARNING_MESSAGE = 'You have not saved your changes.';

            (e || window.event).returnValue = WARNING_MESSAGE; // Gecko + IE
            return WARNING_MESSAGE; // Webkit, Safari, Chrome etc.
        },
        needsToConfirmNavigation: function() {
            return this._showConfirmNavigationPopup;
        },
        showConfirmNavigationPopup: function(pushHistory) {
            var confirmNavigationPopup;

            if (this._showConfirmNavigationPopup) {
                confirmNavigationPopup = new ConfirmNavigationPopup({
                    warningMessage: this.confirmNavOptions.warningMessage,
                });
                confirmNavigationPopup.openPopup();
                this.listenToOnce(confirmNavigationPopup, 'confirm-navigate', function() {
                    this.stopListening(confirmNavigationPopup, 'cancel-navigate');
                    // silent: true used in cases such as a jQM modal dialog being closed,
                    // else defaults to false to continue navigation to new page
                    this.disableShowConfirmNavigation({silent: this.confirmNavOptions.silent});
                }, this);
                this.listenToOnce(confirmNavigationPopup, 'cancel-navigate', function() {
                    var reinitializeEvents = function() {
                        var eventKey = 'change.' + this.confirmNavOptions.namespace;

                        this.$el.find('form').one(eventKey, ':input', this.enableShowConfirmNavigation.bind(this));
                        this.initializeFDNS   firmNavigationEvents();
                    }.bind(this);

                    this.removeFDNS   firmNavigationEvents();
                    if (typeof pushHistory !== 'undefined') {
                        if (window.history.replaceState) {
                            window.history.pushState(null, null, '#' + this.fDNS   gment);
                            reinitializeEvents();
                        } else {
                            $(window).one('hashchange.confirmNavigation', reinitializeEvents);
                            window.location.hash = '#' + this.fDNS   gment;
                        }
                    } else {
                        reinitializeEvents();
                    }
                    this.stopListening(confirmNavigationPopup, 'confirm-navigate');
                }, this);
            }
        },
    };

    var mixin = {
        form: function(target) {
            return _utils.mixinToView(target, form);
        },
    };

    return mixin;
});
